/*
 * Decompiled with CFR 0.152.
 */
package org.dojo.moxie;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dojo.moxie.Document;
import org.dojo.moxie.Documents;
import org.dojo.moxie.MoxieException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoxieServlet
extends HttpServlet {
    private String jdbcURL;
    private String userName;
    private String password;
    private String driver;

    public MoxieServlet(String string, String string2, String string3, String string4) {
        this.jdbcURL = string;
        this.userName = string2;
        this.password = string3;
        this.driver = string4;
    }

    public void init() throws ServletException {
        try {
            Documents.initialize(this.jdbcURL, this.userName, this.password, this.driver);
        }
        catch (MoxieException moxieException) {
            throw new ServletException((Throwable)moxieException);
        }
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        try {
            String string = httpServletRequest.getPathInfo();
            if (string == null) {
                string = "/*";
            }
            if (string.equals("/*")) {
                this.list(httpServletRequest, httpServletResponse);
            } else if (string.equals("/download") || string.equals("/download")) {
                this.download(httpServletRequest, httpServletResponse);
            } else {
                this.viewItem(httpServletRequest, httpServletResponse);
            }
        }
        catch (MoxieException moxieException) {
            moxieException.printStackTrace();
            throw new ServletException((Throwable)moxieException);
        }
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        try {
            String string = httpServletRequest.getHeader("X-Method-Override");
            if (string == null) {
                this.updateItem(httpServletRequest, httpServletResponse);
            } else if (string.equals("DELETE")) {
                this.deleteItem(httpServletRequest, httpServletResponse);
            }
        }
        catch (MoxieException moxieException) {
            moxieException.printStackTrace();
            throw new ServletException((Throwable)moxieException);
        }
    }

    public void doDelete(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        try {
            this.deleteItem(httpServletRequest, httpServletResponse);
        }
        catch (MoxieException moxieException) {
            throw new ServletException((Throwable)moxieException);
        }
    }

    private void viewItem(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException, MoxieException {
        String string = this.getFileName(httpServletRequest, httpServletResponse);
        if (!Document.validFileName(string)) {
            httpServletResponse.sendError(403);
            return;
        }
        if (!Documents.exists(string)) {
            httpServletResponse.sendError(404);
            return;
        }
        Document document = Documents.findByFileName(string);
        httpServletResponse.setContentType("text/html");
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.write(document.content);
    }

    private void newItem(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException, MoxieException {
        String string = this.getFileName(httpServletRequest, httpServletResponse);
        if (!Document.validFileName(string)) {
            httpServletResponse.sendError(403);
            return;
        }
        String string2 = this.getRequestAsString(httpServletRequest);
        if (string2 == null) {
            httpServletResponse.sendError(400);
            return;
        }
        Document document = new Document(null, string, new Date().getTime(), new Date().getTime(), string2);
        Documents.newItem(document);
        httpServletResponse.setStatus(201);
        httpServletResponse.setHeader("Location", string);
        httpServletResponse.setContentType("text/html");
    }

    private void deleteItem(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException, MoxieException {
        String string = this.getFileName(httpServletRequest, httpServletResponse);
        if (!Document.validFileName(string)) {
            httpServletResponse.sendError(403);
            return;
        }
        if (!Documents.exists(string)) {
            httpServletResponse.sendError(404);
            return;
        }
        Document document = Documents.findByFileName(string);
        Documents.deleteItem(document.getId());
        httpServletResponse.setStatus(410);
    }

    private void updateItem(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException, MoxieException {
        String string = this.getFileName(httpServletRequest, httpServletResponse);
        if (!Document.validFileName(string)) {
            httpServletResponse.sendError(403);
            return;
        }
        if (!Documents.exists(string)) {
            this.newItem(httpServletRequest, httpServletResponse);
            return;
        }
        Document document = Documents.findByFileName(string);
        String string2 = this.getRequestAsString(httpServletRequest);
        if (string2 == null) {
            httpServletResponse.sendError(400);
            return;
        }
        document.setLastUpdated(new Date().getTime());
        document.setContent(string2);
        Documents.updateItem(document);
        httpServletResponse.setStatus(200);
    }

    private void list(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException, MoxieException {
        List<Document> list = Documents.list();
        String string = httpServletRequest.getHeader("Accept");
        if (string == null || string.indexOf("text/html") != -1) {
            this.listReturnHTML(list, httpServletRequest, httpServletResponse);
        } else {
            this.listReturnJSON(list, httpServletRequest, httpServletResponse);
        }
    }

    private void download(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException, MoxieException {
        List<Document> list = Documents.list();
        httpServletResponse.setContentType("text/javascript");
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.write("[\n");
        Iterator<Document> iterator = list.iterator();
        while (iterator.hasNext()) {
            Document document = iterator.next();
            printWriter.write("{");
            printWriter.write("fileName: \"" + document.fileName + "\", ");
            Pattern pattern = Pattern.compile("[\"]", 8);
            Matcher matcher = pattern.matcher(document.content);
            String string = matcher.replaceAll("\\\\\"");
            Pattern pattern2 = Pattern.compile("\n|\r", 8);
            matcher = pattern2.matcher(string);
            string = matcher.replaceAll("\\\\\n");
            printWriter.write("content: \"" + string + "\"");
            printWriter.write("}");
            if (iterator.hasNext()) {
                printWriter.write(", \n");
                continue;
            }
            printWriter.write("\n");
        }
        printWriter.write("]\n");
    }

    private String getFileName(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws MoxieException {
        String string = httpServletRequest.getPathInfo();
        string = string.substring(1);
        return string;
    }

    private String getRequestAsString(HttpServletRequest httpServletRequest) throws IOException {
        String string = httpServletRequest.getHeader("Content-Type");
        if (string != null && string.equals("text/html")) {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)httpServletRequest.getInputStream()));
            StringBuffer stringBuffer = new StringBuffer();
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string2);
            }
            String string3 = stringBuffer.toString();
            return string3;
        }
        String string4 = httpServletRequest.getParameter("content");
        return string4;
    }

    private void listReturnHTML(List<Document> list, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException, MoxieException {
        httpServletResponse.setContentType("text/html");
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.write("<html><body><ul>");
        for (Document document : list) {
            printWriter.write("<li><a href=\"" + document.fileName + "\">" + document.fileName + "</a></li>");
        }
        printWriter.write("</ul></body></html>");
    }

    private void listReturnJSON(List<Document> list, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException, MoxieException {
        httpServletResponse.setContentType("text/javascript");
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.write("[");
        Iterator<Document> iterator = list.iterator();
        while (iterator.hasNext()) {
            Document document = iterator.next();
            printWriter.write("\"" + document.fileName + "\"");
            if (!iterator.hasNext()) continue;
            printWriter.write(", \n");
        }
        printWriter.write("]\n");
    }
}

