/*
 * Decompiled with CFR 0.152.
 */
package net.sf.json.util;

import java.beans.PropertyDescriptor;
import net.sf.ezmorph.MorphException;
import net.sf.ezmorph.MorpherRegistry;
import net.sf.ezmorph.ObjectMorpher;
import net.sf.ezmorph.object.IdentityObjectMorpher;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.PropertyUtils;

public class DynaBeanToBeanMorpher
implements ObjectMorpher {
    private final Class beanClass;
    private final MorpherRegistry morpherRegistry;
    static /* synthetic */ Class class$org$apache$commons$beanutils$DynaBean;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$Map;

    public DynaBeanToBeanMorpher(Class beanClass, MorpherRegistry morpherRegistry) {
        this.validateClass(beanClass);
        if (morpherRegistry == null) {
            throw new IllegalArgumentException("morpherRegistry is null");
        }
        this.beanClass = beanClass;
        this.morpherRegistry = morpherRegistry;
    }

    public Object morph(Object value) {
        if (value == null) {
            return null;
        }
        if (!this.supports(value.getClass())) {
            throw new MorphException("value is not a DynaBean");
        }
        Object bean = null;
        try {
            bean = this.beanClass.newInstance();
            DynaBean dynaBean = (DynaBean)value;
            DynaClass dynaClass = dynaBean.getDynaClass();
            PropertyDescriptor[] pds = PropertyUtils.getPropertyDescriptors((Class)this.beanClass);
            for (int i = 0; i < pds.length; ++i) {
                PropertyDescriptor pd = pds[i];
                String name = pd.getName();
                DynaProperty dynaProperty = dynaClass.getDynaProperty(name);
                if (dynaProperty == null) continue;
                Class dynaType = dynaProperty.getType();
                Class<?> type = pd.getPropertyType();
                if (type.isAssignableFrom(dynaType)) {
                    PropertyUtils.setProperty(bean, (String)name, (Object)dynaBean.get(name));
                    continue;
                }
                if (IdentityObjectMorpher.getInstance() == this.morpherRegistry.getMorpherFor(type)) {
                    throw new MorphException("Can't find a morpher for target class " + type);
                }
                PropertyUtils.setProperty(bean, (String)name, (Object)this.morpherRegistry.morph(type, dynaBean.get(name)));
            }
        }
        catch (MorphException me) {
            throw me;
        }
        catch (Exception e) {
            throw new MorphException((Throwable)e);
        }
        return bean;
    }

    public Class morphsTo() {
        return this.beanClass;
    }

    public boolean supports(Class clazz) {
        return (class$org$apache$commons$beanutils$DynaBean == null ? (class$org$apache$commons$beanutils$DynaBean = DynaBeanToBeanMorpher.class$("org.apache.commons.beanutils.DynaBean")) : class$org$apache$commons$beanutils$DynaBean).isAssignableFrom(clazz);
    }

    private void validateClass(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("target class is null");
        }
        if (clazz.isPrimitive()) {
            throw new IllegalArgumentException("target class is a primitive");
        }
        if (clazz.isArray()) {
            throw new IllegalArgumentException("target class is an array");
        }
        if (clazz.isInterface()) {
            throw new IllegalArgumentException("target class is an interface");
        }
        if ((class$org$apache$commons$beanutils$DynaBean == null ? (class$org$apache$commons$beanutils$DynaBean = DynaBeanToBeanMorpher.class$("org.apache.commons.beanutils.DynaBean")) : class$org$apache$commons$beanutils$DynaBean).isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("target class is a DynaBean");
        }
        if ((class$java$lang$Number == null ? (class$java$lang$Number = DynaBeanToBeanMorpher.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(clazz) || (class$java$lang$Boolean == null ? (class$java$lang$Boolean = DynaBeanToBeanMorpher.class$("java.lang.Boolean")) : class$java$lang$Boolean).isAssignableFrom(clazz) || (class$java$lang$Character == null ? (class$java$lang$Character = DynaBeanToBeanMorpher.class$("java.lang.Character")) : class$java$lang$Character).isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("target class is a wrapper");
        }
        if ((class$java$lang$String == null ? (class$java$lang$String = DynaBeanToBeanMorpher.class$("java.lang.String")) : class$java$lang$String).isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("target class is a String");
        }
        if ((class$java$util$Collection == null ? (class$java$util$Collection = DynaBeanToBeanMorpher.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("target class is a Collection");
        }
        if ((class$java$util$Map == null ? (class$java$util$Map = DynaBeanToBeanMorpher.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("target class is a Map");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

